'use strict';

describe('core/core.js', function () {
  beforeEach(module('genisis'));

  var $controller;
  var $rootScope = {};

  beforeEach(inject(function (_$controller_) {
    $controller = _$controller_;
    $rootScope = {};
    $controller('genisisCtrl', {
      $rootScope: $rootScope
    });
  }));

  it('controller exists', function () {
    expect($controller).toBeDefined();
  });

  describe('$rootScope.config', function () {

    it('exists', function () {
      expect($rootScope.config).toBeDefined();
    });

    it('has a logo value', function () {
      expect($rootScope.config.logo).toEqual('images/logo.jpg');
    });

    it('has a pageTitle value', function () {
      expect($rootScope.config.pageTitle)
        .toEqual(
          'Genomic Information System for Integrated Science');
    });

    it('has a copyright value', function () {
      expect($rootScope.config.copyright)
        .toEqual('U.S. Department of Veterans Affairs');
    });

    it('has an address value', function () {
      expect($rootScope.config.address)
        .toEqual('810 Vermont Avenue, NW Washington DC 20420');
    });

    it('has an array to hold errors', function () {
      expect($rootScope.errors).toEqual([]);
    });

    it('has an array to hold warnings', function () {
      expect($rootScope.warnings).toEqual([]);
    });
  });
});